<?php
// Check if Live Composer is active
if ( defined( 'DS_LIVE_COMPOSER_URL' ) ) {

	add_action('dslc_hook_register_modules',
	     create_function('', 'return dslc_register_module( "Intruder_Pricing_Table" );')
	);

	class Intruder_Pricing_Table extends DSLC_Module {

	 	// Module Attributes
	    var $module_id = 'Intruder_Pricing_Table';
	    var $module_title = 'Pricing Table';
	    var $module_icon = 'table';
	    var $module_category = 'elements';

	 	// Module Options
	    function options() {

	    	global $dslc_active;

	    	if ( $dslc_active && is_user_logged_in() && current_user_can( DS_LIVE_COMPOSER_CAPABILITY ) )
	    		$dslc_is_admin = true;
	    	else
	    		$dslc_is_admin = false;

	    	// The options array
	    	$options = array(

	    		array(
	    			'label' => __( 'Show On', 'intruder' ),
	    			'id' => 'ipt_show_on',
	    			'std' => 'desktop tablet phone',
	    			'type' => 'checkbox',
	    			'choices' => array(
	    				array(
	    					'label' => __( 'Desktop', 'intruder' ),
	    					'value' => 'desktop'
	    				),
	    				array(
	    					'label' => __( 'Tablet', 'intruder' ),
	    					'value' => 'tablet'
	    				),
	    				array(
	    					'label' => __( 'Phone', 'intruder' ),
	    					'value' => 'phone'
	    				),
	    			),
	    		),

	    		/* ====== Table Title ====== */

				array(
					'label'      => __( 'Table Title', 'intruder' ),
					'id'         => 'ipt_title',
					'std'        => __( 'Package Name', 'intruder' ),
					'type'       => 'input',
					'visibility' => 'hidden',
					'section'    => 'styling',
					'tab'        => __( 'Table Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'pt_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-title',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Table Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'pt_css_font_family',
					'std'                   => 'Merriweather',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-title',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Table Title', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'pt_css_font_weight',
					'std'                   => '700',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-title',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Table Title', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Size', 'intruder' ),
					'id'                    => 'pt_css_font_size',
					'std'                   => '24',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-title',
					'affect_on_change_rule' => 'font-size',
					'section'               => 'styling',
					'tab'                   => __( 'Table Title', 'intruder' ),
					'ext'                   => 'px'
				),

				/* ====== Table Price ====== */

				array(
					'label'      => __( 'Currency', 'intruder' ),
					'id'         => 'ipt_currency',
					'std'        => '$',
					'type'       => 'input',
					'visibility' => 'hidden',
					'section'    => 'styling'
				),

				array(
					'label'      => __( 'Price', 'intruder' ),
					'id'         => 'ipt_price',
					'std'        => '240',
					'type'       => 'input',
					'visibility' => 'hidden',
					'section'    => 'styling'
				),

				array(
					'label'      => __( 'Tenure', 'intruder' ),
					'id'         => 'ipt_tenure',
					'std'        => 'mo',
					'type'       => 'input',
					'visibility' => 'hidden',
					'section'    => 'styling'
				),

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'ptpr_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-price,.it-tenure',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Table Price', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'ptpr_css_font_family',
					'std'                   => 'Merriweather',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-price,.it-tenure',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Table Price', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'ptpr_css_font_weight',
					'std'                   => '700',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-price,.it-tenure',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Table Price', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Price Border Color', 'intruder' ),
					'id'                    => 'ipt_price_border_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-price,.it-tenure',
					'affect_on_change_rule' => 'border-color',
					'section'               => 'styling',
					'tab'                   => __( 'Table Price', 'intruder' ),
				),

				/* ====== Content ====== */

				array(
					'label'      => __( 'Table Content', 'intruder' ),
					'id'         => 'ipt_content',
					'std'        => '<p>15 Email Accounts</p><p>100GB Space</p><p>1 Domain Name</p><p>500GB Bandwidth</p>',
					'type'       => 'textarea',
					'visibility' => 'hidden',
					'section'    => 'styling'
				),

				array(
					'label'                 => __( 'Color', 'intruder' ),
					'id'                    => 'ptc_css_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-features',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab'                   => __( 'Table Content', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'ptc_css_font_family',
					'std'                   => 'Merriweather Sans',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-features',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Table Content', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'ptc_css_font_weight',
					'std'                   => '300',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-features',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Table Content', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Size', 'intruder' ),
					'id'                    => 'ptc_css_font_size',
					'std'                   => '15',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-features',
					'affect_on_change_rule' => 'font-size',
					'section'               => 'styling',
					'tab'                   => __( 'Table Content', 'intruder' ),
					'ext'                   => 'px'
				),

				/* ====== Button Style ====== */

				array(
					'label'                 => __( 'Button Background', 'intruder' ),
					'id'                    => 'ipt_btn_bg',
					'std'                   => '#277856',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-button',
					'affect_on_change_rule' => 'background-color',
					'section'               => 'styling',
					'tab' 					=> __( 'Table Button', 'intruder' ),
				),

				array(
					'label'                 => __( 'Button Color', 'intruder' ),
					'id'                    => 'ipt_btn_color',
					'std'                   => '#fff',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-button',
					'affect_on_change_rule' => 'color',
					'section'               => 'styling',
					'tab' 					=> __( 'Table Button', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Family', 'intruder' ),
					'id'                    => 'ptbtn_css_font_family',
					'std'                   => 'Merriweather Sans',
					'type'                  => 'font',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-button',
					'affect_on_change_rule' => 'font-family',
					'section'               => 'styling',
					'tab'                   => __( 'Table Button', 'intruder' ),
				),

				array(
					'label'                 => __( 'Font Weight', 'intruder' ),
					'id'                    => 'ptbtn_css_font_weight',
					'std'                   => '300',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-button',
					'affect_on_change_rule' => 'font-weight',
					'section'               => 'styling',
					'tab'                   => __( 'Table Button', 'intruder' ),
					'ext'                   => '',
					'min'                   => 100,
					'max'                   => 900,
					'increment'             => 100
				),

				array(
					'label'                 => __( 'Font Size', 'intruder' ),
					'id'                    => 'ptbtn_css_font_size',
					'std'                   => '15',
					'type'                  => 'slider',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-button',
					'affect_on_change_rule' => 'font-size',
					'section'               => 'styling',
					'tab'                   => __( 'Table Button', 'intruder' ),
					'ext'                   => 'px'
				),

				/* ====== Button ====== */

				array(
					'label'      => __( 'Button', 'intruder' ),
					'id'         => 'ipt_button',
					'std'        => __( 'Select Plan', 'intruder' ),
					'type'       => 'input',
					'visibility' => 'hidden',
					'section'    => 'styling'
				),

				array(
					'label'      => __( 'Button Link', 'intruder' ),
					'id'         => 'ipt_button_link',
					'std'        => '#',
					'type'       => 'input',
				),

				array(
					'label' => __( 'Open In New Tab?', 'intruder' ),
					'id'    => 'ipt_button_tab',
					'std'   => 'fade',
					'type'  => 'select',
					'choices' => array(
						array(
							'label' => __( 'Same Tab', 'intruder' ),
							'value' => '_self'
						),
						array(
							'label' => __( 'New Tab', 'intruder' ),
							'value' => '_blank'
						),
					)
				),

				array(
					'label'                 => __( 'Table Title Background', 'intruder' ),
					'id'                    => 'ipt_title_bg_color',
					'std'                   => '#277856',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-table-title',
					'affect_on_change_rule' => 'background-color',
					'section'               => 'styling',
				),

				array(
					'label'                 => __( 'Table Background', 'intruder' ),
					'id'                    => 'ipt_bg_color',
					'std'                   => '#62af8e',
					'type'                  => 'color',
					'refresh_on_change'     => false,
					'affect_on_change_el'   => '.intruder-pricing-table',
					'affect_on_change_rule' => 'background-color',
					'section'               => 'styling',
				),

	    	);

			$options = array_merge( $options, $this->shared_options( 'animation_options', array( 'hover_opts' => false ) ) );
			$options = array_merge( $options, $this->presets_options() );

	    	// Return the array
	    	return apply_filters( 'dslc_module_options', $options, $this->module_id );
	    }

	 	// Module Output
	    function output( $options ) {

	    	global $dslc_active;

	    	if ( $dslc_active && is_user_logged_in() && current_user_can( DS_LIVE_COMPOSER_CAPABILITY ) )
	    		$dslc_is_admin = true;
	    	else
	    		$dslc_is_admin = false;

	    	// REQUIRED
	    	$this->module_start( $options );

	    	?>

			<div class="intruder-pricing-table">

				<h4 class="intruder-table-title dslca-editable-content" data-id="ipt_title" data-type="simple" <?php if ( $dslc_is_admin ) echo 'contenteditable'; ?>><?php echo esc_html( $options['ipt_title'] ); ?></h4>

				<div class="intruder-table-price">
					<span class="it-currency dslca-editable-content" data-id="ipt_currency" data-type="simple" <?php if ( $dslc_is_admin ) echo 'contenteditable'; ?>><?php echo esc_html( $options['ipt_currency'] ); ?></span>

					<span class="it-price dslca-editable-content" data-id="ipt_price" data-type="simple" <?php if ( $dslc_is_admin ) echo 'contenteditable'; ?>><?php echo esc_html( $options['ipt_price'] ); ?></span>

					<span class="it-tenure dslca-editable-content" data-id="ipt_tenure" data-type="simple" <?php if ( $dslc_is_admin ) echo 'contenteditable'; ?>><?php echo esc_html( $options['ipt_tenure'] ); ?></span>
				</div>


				<div class="intruder-table-features">

					<?php if ( $dslc_is_admin ) : ?>
						<div class="dslca-editable-content" data-id="ipt_content">
							<?php echo stripslashes( $options['ipt_content'] ); ?>
						</div><!-- .dslca-editable-content -->
						<div class="dslca-wysiwyg-actions-edit"><span class="dslca-wysiwyg-actions-edit-hook"><?php _e( 'Edit Content', 'live-composer-page-builder' ); ?></span></div>
					<?php else : ?>
						<?php echo do_shortcode( stripslashes( $options['ipt_content'] ) ); ?>
					<?php endif; ?>

				</div>

				<a target="<?php echo esc_attr( $options['ipt_button_tab'] ); ?>" href="<?php echo esc_url( $options['ipt_button_link'] ); ?>" class="button intruder-table-button  dslca-editable-content" data-id="ipt_button" data-type="simple" <?php if ( $dslc_is_admin ) echo 'contenteditable'; ?>><?php echo $options['ipt_button']; ?></a>
			</div>

	    	<?php

	    	// REQUIRED
	    	$this->module_end( $options );

	    }

	}

}
?>