<?php

add_filter( 'dslc_module_options', 'alter_lc_defaults', 10, 2 );

function alter_lc_defaults( $options, $id ) {

	// The array that will hold new defaults
	$new_defaults = array();

	if ( $id == 'DSLC_Info_Box' ) {
		$new_defaults = array(
			'elements'                => 'icon title content ',
			'css_icon_bg_color'       => 'rgba(31, 18, 18, 0)',
			'css_icon_border_trbl'    => '',
			'css_icon_color'          => 'rgb(241, 77, 12)',
			'icon_id'                 => 'newspaper-o',
			'css_icon_margin_bottom'  => '16',
			'css_icon_wrapper_width'  => '86',
			'css_icon_width'          => '84',
			'css_title_color'         => 'rgb(102, 102, 102)',
			'css_title_font_size'     => '20',
			'css_title_font_weight'   => '400',
			'css_title_font_family'   => 'Merriweather',
			'css_title_margin'        => '17',
			'css_content_color'       => 'rgb(136, 136, 136)',
			'css_content_font_weight' => '300',
			'css_content_font_family' => 'Merriweather Sans',
			'css_content_line_height' => '22',
			'title'                   => 'Stunning Layout<br>',
			'content'                 => '<p>Sed ut perspiciatis unde omnis iste sit voluptatem accusantium doloreme totam rem aperiam, eaque ipsa quae.</p>',
		);
	}

	if ( $id == 'DSLC_Posts' ) {
		$new_defaults = array(
			'sticky_posts'                => 'disabled',
			'post_elements'               => 'thumbnail title meta excerpt ',
			'css_wrapper_border_trbl'     => '',
			'css_thumb_border_trbl'       => '',
			'css_thumb_border_radius_top' => '0',
			'css_main_border_width'       => '0',
			'css_main_border_trbl'        => '',
			'css_main_padding_vertical'   => '19',
			'css_main_padding_horizontal' => '0',
			'title_color'                 => 'rgb(102, 102, 102)',
			'css_title_font_family'       => 'Merriweather',
			'title_margin'                => '12',
			'css_meta_border_color'       => 'rgb(237, 237, 237)',
			'css_meta_color'              => 'rgb(128, 128, 128)',
			'css_meta_font_size'          => '13',
			'css_meta_font_family'        => 'Merriweather',
			'css_meta_margin_bottom'      => '11',
			'css_meta_padding_vertical'   => '7',
			'css_meta_link_color'         => 'rgb(136, 136, 136)',
			'css_meta_link_color_hover'   => 'rgb(136, 136, 136)',
			'css_excerpt_color'           => 'rgb(128, 128, 128)',
			'css_excerpt_font_size'       => '14',
			'css_excerpt_font_weight'     => '300',
			'css_excerpt_font_family'     => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Galleries' ) {
		$new_defaults = array(
			'type'                             => 'grid',
			'post_elements'                    => 'thumbnail ',
			'separator_enabled'                => 'disabled',
			'css_sep_height'                   => '0',
			'css_sep_thickness'                => '0',
			'css_thumbnail_bg_color'           => 'rgba(126, 99, 99, 0)',
			'css_thumb_border_color'           => 'rgba(159, 108, 108, 0)',
			'css_thumb_border_width'           => '0',
			'css_thumb_border_trbl'            => '',
			'css_thumbnail_padding_vertical'   => '0',
			'css_thumbnail_padding_horizontal' => '0',
			'css_main_padding_vertical'        => '25',
			'css_main_padding_horizontal'      => '26',
		);
	}

	if ( $id == 'DSLC_TP_Title' ) {
		$new_defaults = array(
			'css_font_family' => 'Merriweather Sans'
		);
	}

	if ( $id == 'DSLC_TP_Excerpt' ) {
		$new_defaults = array(
			'css_font_family' => 'Merriweather Sans',
			'css_font_size'   => '16',
			'css_font_weight' => '300',
			'css_line_height' => '24', // 16*1.5
		);
	}

	if ( $id == 'DSLC_TP_Meta' ) {
		$new_defaults = array(
			'css_font_family' => 'Merriweather Sans',
			'font_size'       => '15', // no css_ prefix
			'css_font_style'  => 'italic',
			'css_font_weight' => '300',
			'css_line_height' => '24',
		);
	}

	if ( $id == 'DSLC_TP_Downloads_Button' ) {
		$new_defaults = array(
			'css_button_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_TP_Comments' ) {
		$new_defaults = array(
			'css_ia_font_weight' => '300',
			'css_ia_font_family' => 'Merriweather Sans',
			'css_id_font_weight' => '300',
			'css_id_font_family' => 'Merriweather Sans',
			'css_ir_font_weight' => '300',
			'css_ir_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_TP_Comments_Form' ) {
		$new_defaults = array(
			'css_heading_font_size'   => '21',
			'css_heading_font_weight' => '700',
			'css_heading_font_family' => 'Merriweather Sans',
			'css_heading_line_height' => '30',
			'css_inputs_font_family'  => 'Merriweather Sans',
			'css_button_font_family'  => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Accordion' ) {
		$new_defaults = array(
			'css_title_font_family'   => 'Merriweather Sans',
			'css_content_font_weight' => '300',
			'css_content_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Text_Simple' ) {
		$new_defaults = array(

			'css_main_font_size'   => '16',
			'css_main_font_weight' => '300',
			'css_main_line_height' => '24',
			'css_main_font_family' => 'Merriweather Sans',

			'css_h1_font_size'   => '27',
			'css_h1_font_weight' => '700',
			'css_h1_font_family' => 'Merriweather Sans',
			'css_h1_line_height' => '40',

			'css_h2_font_size'   => '25',
			'css_h2_font_weight' => '700',
			'css_h2_font_family' => 'Merriweather Sans',
			'css_h2_line_height' => '37',

			'css_h3_font_size'   => '23',
			'css_h3_font_weight' => '700',
			'css_h3_font_family' => 'Merriweather Sans',
			'css_h3_line_height' => '35',

			'css_h4_font_size'   => '21',
			'css_h4_font_weight' => '700',
			'css_h4_font_family' => 'Merriweather Sans',
			'css_h4_line_height' => '32',

			'css_h5_font_size'   => '19',
			'css_h5_font_weight' => '700',
			'css_h5_font_family' => 'Merriweather Sans',
			'css_h5_line_height' => '29',

			'css_h6_font_size'   => '17',
			'css_h6_font_weight' => '700',
			'css_h6_font_family' => 'Merriweather Sans',
			'css_h6_line_height' => '26',

			'css_inputs_font_size'   => '16',
			'css_inputs_font_weight' => '700',
			'css_inputs_font_family' => 'Merriweather Sans',
			'css_inputs_line_height' => '24',

			'css_li_font_size'   => '16',
			'css_li_font_weight' => '300',
			'css_li_font_family' => 'Merriweather Sans',
			'css_li_line_height' => '24',

			'css_blockquote_font_size'   => '16',
			'css_blockquote_font_weight' => '300',
			'css_blockquote_font_family' => 'Merriweather Sans',
			'css_blockquote_line_height' => '24',

			'css_button_font_size'   => '16',
			'css_button_font_weight' => '700',
			'css_button_font_family' => 'Merriweather Sans',
			'css_button_line_height' => '24',

		);
	}

	if ( $id == 'DSLC_Blog' ) {
		$new_defaults = array(
			'sticky_posts'                => 'disabled',
			'post_elements'               => 'thumbnail title meta excerpt ',
			'css_wrapper_border_trbl'     => '',
			'css_thumb_border_trbl'       => '',
			'css_thumb_border_radius_top' => '0',
			'css_main_border_width'       => '0',
			'css_main_border_trbl'        => '',
			'css_main_padding_vertical'   => '19',
			'css_main_padding_horizontal' => '0',
			'title_color'                 => 'rgb(102, 102, 102)',
			'css_title_font_family'       => 'Merriweather',
			'title_margin'                => '12',
			'css_meta_border_color'       => 'rgb(237, 237, 237)',
			'css_meta_color'              => 'rgb(128, 128, 128)',
			'css_meta_font_size'          => '13',
			'css_meta_font_family'        => 'Merriweather',
			'css_meta_margin_bottom'      => '11',
			'css_meta_padding_vertical'   => '7',
			'css_meta_link_color'         => 'rgb(136, 136, 136)',
			'css_meta_link_color_hover'   => 'rgb(136, 136, 136)',
			'css_excerpt_color'           => 'rgb(128, 128, 128)',
			'css_excerpt_font_size'       => '14',
			'css_excerpt_font_weight'     => '300',
			'css_excerpt_font_family'     => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Projects' ) {
		$new_defaults = array(
			'css_title_color'         => 'rgb(102, 102, 102)',
			'css_title_font_size'     => '20',
			'css_title_font_family'   => 'Merriweather',
			'css_title_font_weight'   => '400',
			'css_title_margin_bottom' => '20',

			'css_cats_font_size'      => '13',
			'css_cats_font_family'    => 'Merriweather',
			'css_cats_font_weight'    => '400',
			'css_cats_margin-bottom'  => '15',

			'css_excerpt_font_size'   => '14',
			'css_excerpt_font_weight' => '300',
			'css_excerpt_font_family' => 'Merriweather Sans',

			'css_button_font_size'    => '12',
			'css_button_font_weight'  => '700',
			'css_button_font_family'  => 'Merriweather Sans',
			'css_button_line_height'  => '24',
		);
	}

	if ( $id == 'DSLC_Galleries' ) {
		$new_defaults = array(
			'css_title_color'         => 'rgb(102, 102, 102)',
			'css_title_font_size'     => '20',
			'css_title_font_family'   => 'Merriweather',
			'css_title_font_weight'   => '400',

			'css_excerpt_font_size'   => '14',
			'css_excerpt_font_weight' => '300',
			'css_excerpt_font_family' => 'Merriweather Sans',

			'css_button_font_size'    => '12',
			'css_button_font_weight'  => '700',
			'css_button_font_family'  => 'Merriweather Sans',
			'css_button_line_height'  => '24',

			'css_count_num_font_weight'       => '300',
			'css_count_num_color_font_family' => 'Merriweather Sans',
			'css_count_txt_font_weight'       => '300',
			'css_count_txt_color_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Downloads' ) {
			$new_defaults = array(
				'css_main_padding_vertical' => '19',
				'css_title_color'           => 'rgb(102, 102, 102)',
				'css_title_font_family'     => 'Merriweather',
				'css_title_margin'          => '12',

				'css_tags_font_size'        => '13',
				'css_tags_font_family'      => 'Merriweather',
				'css_tags_font_weight'      => '400',
				'css_tags_margin-bottom'    => '15',

				'css_excerpt_color'         => 'rgb(128, 128, 128)',
				'css_excerpt_font_size'     => '14',
				'css_excerpt_font_weight'   => '300',
				'css_excerpt_font_family'   => 'Merriweather Sans',

				'css_button_font_size'      => '12',
				'css_button_font_weight'    => '700',
				'css_button_font_family'    => 'Merriweather Sans',
				'css_button_line_height'    => '24',

				'css_count_font_size'       => '12',
				'css_count_font_family'     => 'Merriweather Sans',
				'css_count_font_weight'     => '300',
				'css_count_margin-bottom'   => '15',
			);
	}

	if ( $id == 'DSLC_Testimonials' ) {
		$new_defaults = array(
			'css_quote_font_size'      => '21',
			'css_quote_line_height'    => '32',
			'css_quote_font_weight'    => '300',
			'css_quote_font_family'    => 'Merriweather Sans',

			'css_name_font_size'       => '18',
			'css_name_font_weight'     => '700',
			'css_name_font_family'     => 'Merriweather Sans',

			'css_position_font_size'   => '18',
			'css_position_font_weight' => '700',
			'css_position_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Staff' ) {
		$new_defaults = array(
			'css_title_font_size'      => '20',
			'css_title_font_weight'    => '400',
			'css_title_font_family'    => 'Merriweather Sans',

			'css_position_font_size'   => '16',
			'css_position_font_weight' => '300',
			'css_position_font_family' => 'Merriweather Sans',
			'css_position_font_style'  => 'italic',

			'css_excerpt_font_size'    => '14',
			'css_excerpt_font_weight'  => '300',
			'css_excerpt_font_family'  => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Partners' ) {
		$new_defaults = array(
			'css_title_font_size'     => '20',
			'css_title_font_weight'   => '400',
			'css_title_font_family'   => 'Merriweather',
			'css_title_margin_bottom'  => '20',

			'css_excerpt_font_size'   => '14',
			'css_excerpt_font_weight' => '300',
			'css_excerpt_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_WooCommerce_Products' ) {
		$new_defaults = array(
			'css_title_font_size'       => '16',
			'css_title_font_weight'     => '300',
			'css_title_font_family'     => 'Merriweather',

			'css_price_font_weight'     => '700',
			'css_price_font_family'     => 'Merriweather Sans',

			'css_excerpt_font_size'     => '15',
			'css_excerpt_font_weight'   => '300',
			'css_excerpt_font_family'   => 'Merriweather Sans',

			'css_price_2_font_weight'   => '700',
			'css_price_2_font_family'   => 'Merriweather Sans',

			'css_addtocart_font_size'   => '15',
			'css_addtocart_font_weight' => '400',
			'css_addtocart_font_family' => 'Merriweather Sans',

			'css_details_font_size'     => '15',
			'css_details_font_weight'   => '400',
			'css_details_font_family'   => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Notification' ) {
		$new_defaults = array(
			'css_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Button' ) {
		$new_defaults = array(
			'css_button_font_family' => 'Merriweather Sans',
		);
	}

	if ( $id == 'DSLC_Tabs' ) {
		$new_defaults = array(

			'css_nav_font_size'   => '16',
			'css_nav_font_weight' => '400',
			'css_nav_line_height' => '24',
			'css_nav_font_family' => 'Merriweather',

			'css_content_font_size'   => '16',
			'css_content_font_weight' => '300',
			'css_content_line_height' => '24',
			'css_content_font_family' => 'Merriweather Sans',

			'css_h1_font_size'   => '27',
			'css_h1_font_weight' => '700',
			'css_h1_font_family' => 'Merriweather Sans',
			'css_h1_line_height' => '40',

			'css_h2_font_size'   => '25',
			'css_h2_font_weight' => '700',
			'css_h2_font_family' => 'Merriweather Sans',
			'css_h2_line_height' => '37',

			'css_h3_font_size'   => '23',
			'css_h3_font_weight' => '700',
			'css_h3_font_family' => 'Merriweather Sans',
			'css_h3_line_height' => '35',

			'css_h4_font_size'   => '21',
			'css_h4_font_weight' => '700',
			'css_h4_font_family' => 'Merriweather Sans',
			'css_h4_line_height' => '32',

			'css_h5_font_size'   => '19',
			'css_h5_font_weight' => '700',
			'css_h5_font_family' => 'Merriweather Sans',
			'css_h5_line_height' => '29',

			'css_h6_font_size'   => '17',
			'css_h6_font_weight' => '700',
			'css_h6_font_family' => 'Merriweather Sans',
			'css_h6_line_height' => '26',

			'css_inputs_font_size'   => '16',
			'css_inputs_font_weight' => '700',
			'css_inputs_font_family' => 'Merriweather Sans',
			'css_inputs_line_height' => '24',

			'css_li_font_size'   => '16',
			'css_li_font_weight' => '300',
			'css_li_font_family' => 'Merriweather Sans',
			'css_li_line_height' => '24',

			'css_blockquote_font_size'   => '16',
			'css_blockquote_font_weight' => '300',
			'css_blockquote_font_family' => 'Merriweather Sans',
			'css_blockquote_line_height' => '24',

		);
	}

	if ( $id == 'DSLC_Navigation' ) {
		$new_defaults = array(
			'css_item_font_family'        => 'Merriweather Sans',
			'css_subnav_item_font_family' => 'Merriweather Sans',
		);
	}

	// Call the function that alters the defaults and return
	return dslc_set_defaults( $new_defaults, $options );

}

?>