<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<time <?php hybrid_attr( 'entry-published' ); ?>>
			<span><?php echo get_the_date('d'); ?></span>
			<?php echo get_the_date('F'); ?>
		</time>

		<header class="entry-header">
			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" itemprop="url">', '</a></h1>' ); ?>
			<div class="entry-byline">
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php echo __( 'by', 'intruder' ), ' ', the_author_posts_link(); ?></span>,
				<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'In %s', 'intruder' ) ) ); ?>,
				<?php comments_popup_link(
					__( '0 comments', 'intruder' ),
					__( '1 comment', 'intruder' ),
					__( '% comments', 'intruder' ),
					'comments-link',
					__( 'Comments Off', 'intruder' ) ); ?>
				<?php edit_post_link( __( 'Edit', 'intruder' ) ); ?>
			</div><!-- .entry-byline -->
		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'sep' => '' ) ); ?>
			<div class="posts-nav">
				<?php previous_post_link( '<div class="post-nav prev">' . __( 'Previous Post: %link', 'intruder' ) . '</div>', '%title' ); ?>
				<?php next_post_link( '<div class="post-nav next">' . __( 'Next Post: %link',     'intruder' ) . '</div>', '%title' ); ?>
			</div>
 		</footer><!-- .entry-footer -->

	<?php else : // If not viewing a single post. ?>

		<?php get_the_image( array( 'size' => 'intruder-full', 'order' => array( 'featured', 'attachment' ) ) ); ?>

		<time <?php hybrid_attr( 'entry-published' ); ?>>
			<span><?php echo get_the_date('d'); ?></span>
			<?php echo get_the_date('F'); ?>
		</time>

		<header class="entry-header">
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			<div class="entry-byline">
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php echo __( 'by', 'intruder' ), ' ', the_author_posts_link(); ?></span>,
				<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'In %s', 'intruder' ) ) ); ?>,
				<?php comments_popup_link(
					__( '0 comments', 'intruder' ),
					__( '1 comment', 'intruder' ),
					__( '% comments', 'intruder' ),
					'comments-link',
					__( 'Comments Off', 'intruder' ) ); ?>
				<?php edit_post_link( __( 'Edit', 'intruder' ) ); ?>
			</div><!-- .entry-byline -->
		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			<?php the_excerpt(''); ?>
		</div><!-- .entry-summary -->

		<footer class="entry-footer">
			<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'intruder' ); ?></a>
 		</footer><!-- .entry-footer -->

	<?php endif; // End single post check. ?>

</article><!-- .entry -->