<?php 

/* Theme Customizer setup. */
add_action( 'customize_register', 'losatom_customizer_options', 20 );

/**
 * Sets up the theme customizer sections, controls, and settings.
 *
 * @since  1.0.0
 * @access public
 * @param  object  $wp_customize
 * @return void
 */
function losatom_customizer_options( $wp_customize ) {

	/* === Site Identity === */

	$wp_customize->add_setting( 'logo', array(
		'default'           => trailingslashit( get_template_directory_uri() ) . 'images/logo.png',
		'sanitize_callback' => 'esc_url_raw'
	) );
	 
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'logo',
	        array(
				'label'       => __( 'Logo Upload', 'losatom' ),
				'description' => __( 'If you remove logo, site title will be used instead.', 'losatom' ),
				'section'     => 'title_tagline',
				'settings'    => 'logo',
				'priority'    => 1,					
	        )
	    )
	);

	$wp_customize->add_setting( 'site_tagline_toggle', array( 
		'default'           => 0,
		'sanitize_callback' => 'losatom_sanitize_checkbox'
	) );

	$wp_customize->add_control( 'site_tagline_toggle', array(
		'label'    => __( 'Show site tagline?', 'losatom' ),
		'type'     => 'checkbox',
		'section'  => 'title_tagline',
		'settings' => 'site_tagline_toggle',
	) );	

	$wp_customize->add_section( 'section_scripts', array(
		'title'           => 'Front Page Scripts',
		'panel'           => 'front_page_sections',
    ) );

	$wp_customize->add_setting( 'show_preloader', array( 
		'default'           => 1,
		'sanitize_callback' => 'losatom_sanitize_checkbox'			
	) );

	$wp_customize->add_control( 'show_preloader', array(
		'label'    => __( 'Show preloader on front page?', 'losatom' ),
		'type'     => 'checkbox',
		'section'  => 'section_scripts',
		'settings' => 'show_preloader',
	) );

	$wp_customize->add_setting( 'show_animations', array( 
		'default'           => 1,
		'sanitize_callback' => 'losatom_sanitize_checkbox'			
	) );

	$wp_customize->add_control( 'show_animations', array(
		'label'    => __( 'Show animations on front page?', 'losatom' ),
		'type'     => 'checkbox',
		'section'  => 'section_scripts',
		'settings' => 'show_animations',
	) );		

	$wp_customize->add_section( 'section_header', array(
		'title'    => 'Header Options',
		'priority' => 20,
		'panel'    => 'losatom_general'		
    ) );

	$wp_customize->add_setting( 'call_text', array( 
		'default'           => __( 'Call Us:', 'losatom' ),
		'sanitize_callback' => 'losatom_sanitize_text'
	) );

	$wp_customize->add_control( 'call_text', array(
		'label'    => __( 'Call Us Text:', 'losatom' ),
		'section'  => 'section_header',
		'settings' => 'call_text',
	) );	

	$wp_customize->add_setting( 'phone_number', array( 
		'default'           => '+1 899-777-5555',
		'sanitize_callback' => 'losatom_sanitize_text'			
	) );

	$wp_customize->add_control( 'phone_number', array(
		'label'    => __( 'Phone Number:', 'losatom' ),
		'section'  => 'section_header',
		'settings' => 'phone_number',
	) );		

	$wp_customize->add_section( 'section_separator', array(
		'title'           => 'Separator Options',
		'priority'        => 21,
		'panel'           => 'blog_options',
    ) );

	$wp_customize->add_setting( 'loop_title', array( 
		'default'           => __( 'From the blog', 'losatom' ),
		'sanitize_callback' => 'losatom_sanitize_text',			
	) );
 
	$wp_customize->add_control( 'loop_title', array(
		'label'    => __( 'Separator Title:', 'losatom' ),
		'section'  => 'section_separator',
		'settings' => 'loop_title',
	) );	

	$wp_customize->add_setting( 'loop_img', array(
		'default'           => trailingslashit( get_template_directory_uri() ) . 'images/sep.jpg',
		'sanitize_callback' => 'esc_url_raw',			
	) );
	 
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'loop_img',
	        array(
				'label'    => __( 'Separator Background Image', 'losatom' ),
				'section'  => 'section_separator',
				'settings' => 'loop_img',
	        )
	    )
	);

	/* === Footer Options === */
	
	$wp_customize->add_section( 'section_footer_options', array(
		'title'    => 'Footer Options',
		'priority' => 23,
		'panel'    => 'losatom_general'		
    ) );

	$wp_customize->add_setting( 'footer_text', array( 
		'default'           => __( 'All rights reserved.', 'losatom' ),
		'sanitize_callback' => 'losatom_sanitize_text',						
	) );

	$wp_customize->add_control( 'footer_text', array(
		'label'    => __( 'Footer Text:', 'losatom' ),
		'section'  => 'section_footer_options',
		'settings' => 'footer_text',
	) );

	/* === PANEL: General === */

	$wp_customize->add_panel( 'losatom_general', array(
	    'priority'       => 22,
	    'capability'     => 'edit_theme_options',
	    'title'          => 'General Options',
	    'description'    => '',
	) );	

	/* === PANEL: Front Page === */

	$wp_customize->add_panel( 'front_page_sections', array(
	    'priority'       => 23,
	    'capability'     => 'edit_theme_options',
	    'title'          => 'Front Page',
	    'description'    => '',
	) );		

	/* === PANEL: Blog Options === */

	$wp_customize->add_panel( 'blog_options', array(
		'priority'        => 24,
		'capability'      => 'edit_theme_options',
		'title'           => 'Blog Options',
		'description'     => '',
	) );		

	
	/* === REORDERING === */

	/* Remove hybrid-core default layout section. */
    $wp_customize->remove_section( 'layout' );

	/* Re-add the layout section. */
	$wp_customize->add_section(
		'layout',
		array(
			'title'           => esc_html__( 'Layouts Options', 'losatom' ),
			'priority'        => 22,
			'capability'      => 'edit_theme_options',
			'panel' 		  => 'blog_options'
		)
	);    

    /* Remove default wp title_tagline section. */
    $wp_customize->remove_section( 'title_tagline' );	

    /* Re-add it to general section. */
	$wp_customize->add_section( 'title_tagline', array(
		'title'      => __( 'Site Identity', 'losatom' ),
		'priority'   => 19,
		'capability' => 'edit_theme_options',
		'panel'      => 'losatom_general'		
	) );

    /* Remove wp's default static front page section. */
    $wp_customize->remove_section( 'static_front_page' );

	/* Re-add the front page section. */
	$wp_customize->add_section(
		'static_front_page',
		array(
			'title'           => esc_html__( 'Static Front Page', 'losatom' ),
			'capability'      => 'edit_theme_options',
			'panel' 		  => 'front_page_sections'
		)
	);  

	/* Remove white sidebar from widgets panel. */
    $wp_customize->remove_section( 'sidebar-widgets-front_page_white' );

	/* Re-add the front page section. */
	$wp_customize->add_section(
		'sidebar-widgets-front_page_white',
		array(
			'title'           => esc_html__( 'Sidebar: Front Page', 'losatom' ),
			'capability'      => 'edit_theme_options',
			'panel' 		  => 'front_page_sections'
		)
	);    	    

	/* Remove white sidebar from widgets panel. */
    $wp_customize->remove_section( 'sidebar-widgets-primary' );

	/* Re-add the front page section. */
	$wp_customize->add_section(
		'sidebar-widgets-primary',
		array(
			'title'           => esc_html__( 'Sidebar: Primary', 'losatom' ),
			'capability'      => 'edit_theme_options',
			'panel' 		  => 'blog_options'
		)
	);  


	/*----------  Live Preview  ----------*/
	
	/* Load JavaScript files. */
	add_action( 'customize_preview_init', 'losatom_enqueue_customizer_scripts' );	 

	/* Enable live preview for WordPress theme features. */
	$wp_customize->get_setting( 'blogname' )->transport             = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport      = 'postMessage';	
	$wp_customize->get_setting( 'call_text' )->transport            = 'postMessage';	
	$wp_customize->get_setting( 'phone_number' )->transport         = 'postMessage';	
	$wp_customize->get_setting( 'loop_title' )->transport           = 'postMessage';	
	$wp_customize->get_setting( 'footer_text' )->transport          = 'postMessage';		
}


/**
 * Loads theme customizer JavaScript.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function losatom_enqueue_customizer_scripts() {

	/* Use the .min script if SCRIPT_DEBUG is turned off. */
	$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script(
		'losatom-customize',
		trailingslashit( get_template_directory_uri() ) . "js/theme-customizer{$suffix}.js",
		array( 'jquery', 'customize-preview' ),		
		null,
		true
	);
}

/*==============================================
=            SANITIZATION CALLBACKS            =
==============================================*/

/**
 * Sanitizes checkbox fields in customizer.
 * 
 * @since 1.0.0
 * @access public
 * @param  bool 	$input 
 * @return int|bool
 */
function losatom_sanitize_checkbox( $input ) {
	return ( $input == 1 ) ? 1 : false;
}

/**
 * Sanitizes text in customizer.
 *
 * @since 1.0.0
 * @access public
 * @param  string 	$input 
 * @return string        
 */
function losatom_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}

/**
 * Sanitizes opacity for background image. Returns 0, 1, and everything between 0.01-0.99.
 *
 * @since 1.0.0
 * @access public
 * @param  string  	$value 
 * @return int|float        
 */
function losatom_sanitize_opacity( $value ) {   
    $value = abs( $value );

    if ( $value > 0 && $value < 1 )
        $value = number_format( $value, 2, '.', '' );

    return ( $value > 1 ) ? 1 : $value;
}

/*=====  End of SANITIZATION CALLBACKS  ======*/

?>