<?php

/* Get the sticky posts. */
global $sticky, $sticky_slider;

if (  $sticky_slider == 1 && ! empty( $sticky ) && ( is_home() || is_front_page() ) ) :
 
	/* Grab all sticky posts */
	$args = array( 'post__in' => $sticky );
	
	$swt_slider = new WP_Query( $args );
	
	if ( $swt_slider->have_posts() ) : ?>

		<section id="slider">
			
			<ul class="bxslider">
			
				<?php while ( $swt_slider->have_posts() ) : $swt_slider->the_post(); ?>	

				<li>
				
					<article class="slide">
												
					<?php if ( current_theme_supports( 'get-the-image' ) ) { 
					get_the_image( array( 
					'default_image' => trailingslashit( get_template_directory_uri() ) . 'images/slider-default.gif',
					'size' => 'full', 
					'image_class' => 'swt-slider-image'
					) ); } 
					?>
																								
					<div class="overlay">
						<div class="bx-caption">
							<div class="wrap">					
							 <div class="slide-content">					
								<h2 class="slider-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>				
								<i class="fa fa-newspaper-o"></i>								
								<span class="slider-cat">								
								<?php $category = get_the_category(); 
								if ( $category[0] ){
									echo '<a href="'. esc_url( get_category_link($category[0]->term_id ) ) .'">' . esc_attr( $category[0]->cat_name ).'</a>';
								}
								?>																		
								</span>									
								<div class="slide-entry clear">
									<p><?php truncate_post(250, true); ?></p>
								</div>								
						     </div>
							 <div class="slide-footer">
				               <time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date( 'M d, Y' ); ?></time>		
							   <span class="slide-avatar"><?php echo get_avatar( get_the_author_meta( 'email' ) ); ?></span>
							 </div>
						    </div>
						</div>
					</div>
										
					</article> <!-- .slide -->
					
				</li>
				
				<?php endwhile; ?>
				
				<?php wp_reset_postdata(); // Restores the $post global to the current post in the main query.  ?>
				    			
			</ul><!-- .bxslider -->
			
		</section><!-- #slider -->

	<?php endif; ?>
		
<?php endif; ?>