jQuery(document).ready(function() {

	/*==== RESPONSIVE PRIMARY MENU SETUP ====*/
	var nav = responsiveNav("#menu-primary-items", { 
		animate: true, 
		transition: 300, 
		insert: "before", 
		customToggle: "#toggle-primary-menu", 
		closeOnNavClick: false, 
		openPos: "relative", 
		navClass: "nav-collapse", 
		navActiveClass: "js-nav-active", 
		jsClass: "js" 
	}); 
 
	/* ===== Fitvids ===== */
	jQuery(".entry-attachment, .entry").fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], iframe[src*='www.viddler.com']"});	
			
	/* ===== Mailchimp ===== */
	if ( options.is_singular == 1 ) {
		
		jQuery('#signup').submit(function() {
			jQuery('#response').html(options.adding_msg);
			var file_path = jQuery('.hidden_path').val();
		
			fnameDef = escape( options.fname );		
			fnameTyped = escape( jQuery('#fname').val() );
						
			if ( fnameDef != fnameTyped )			
				fname = fnameTyped;
			else
				fname = '';
		
			jQuery.ajax({
				url: file_path,
				data: 'ajax=true&email=' + escape(jQuery('#email').val()) + '&fname=' + fname + '&_mailchimp_key=' + escape(jQuery('#_mailchimp_key').val()) + '&_mailchimp_list=' + escape(jQuery('#_mailchimp_list').val()),
				success: function(msg) {
					jQuery('#response').html(msg);
				}
			});
			return false;
		});		
	}
	
	/* ===== ImagesLoaded, Masonry + Infinite Scroll ===== */	
	if ( options.is_singular == "" ) {
	
		var $container = jQuery('#content');
		
		$container.imagesLoaded( function() {

			$container.masonry({
				itemSelector: '.entry'		
			});
		
		});

		$container.infinitescroll({

			navSelector : ".pagination",
			nextSelector : ".pagination a",
			itemSelector : ".entry",
			loading: {
				msg: null,		
				finishedMsg: options.finishedMsg,
				msgText: '<i class="fa fa-spinner fa-spin"></i>'
			}
		},
			 
		function( newElements ) {
			var $newElems = jQuery( newElements ).css({ opacity: 0 });
			$newElems.imagesLoaded(function(){
				$newElems.animate({ opacity: 1 });
				$container.masonry( 'appended', $newElems, true );
			});
			jQuery('audio,video').mediaelementplayer({
				videoWidth: '100%',
				videoHeight: '100%',
				audioWidth: '100%',
				alwaysShowControls: true,
				features: ['playpause','progress','tracks','volume'],
				videoVolume: 'horizontal'
			});
			jQuery(".entry-attachment, .entry").fitVids({ customSelector: "iframe[src*='wordpress.tv'], iframe[src*='www.dailymotion.com'], iframe[src*='blip.tv'], 	iframe[src*='www.viddler.com']"});	
			
			
		});
	}
});