<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">

			<?php the_title( '<h1 ' . hybrid_get_attr( 'entry-title' ) . '>', '</h1>' ); ?>			

			<div class="entry-byline">				
				<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>	
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'By', 'swt' ); ?> <?php the_author_posts_link(); ?></span>
				<?php hybrid_post_terms( array( 'taxonomy' => 'category', 'text' => __( 'In %s', 'swt' ) ) ); ?>
			</div>
						
		</header><!-- .entry-header -->
				
		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">
				<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged With: %s', 'swt' ) ) ); ?>			
			</footer><!-- .entry-footer -->
		
		<?php endif; ?>			
		
	<?php else : // If not viewing a single post. ?>

			
		<?php get_the_image( array( 'link_to_post' => false, 'size' => 'swt-fp', 'order' => array( 'featured', 'attachment' ), 'before' => '<figure class="img-wrap">', 'after' => '<span class="img-overlay"><a class="link-to-post" href="'. get_the_permalink() .'"><i class="fa fa-level-up"></i></a></span></figure>' ) );?>		
	
		<header class="entry-header">
		
			<time <?php hybrid_attr( 'entry-published' ); ?>><?php echo get_the_date('F d, Y'); ?></time>									
			
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			 			
		</header><!-- .entry-header -->
	
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
						
			<?php the_excerpt(''); ?>
			
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer">
					
			<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'swt' ); ?></a>									
			
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->