<?php

class swt_number_of_followers extends WP_Widget {

	function swt_number_of_followers() {
		
		$widget_options = array( 'classname' => 'swt_followers_number', 'description' => __( 'Displays number of followers on social networks.', 'swt' ) );
		parent::WP_Widget( 'swt_number_of_followers', __( 'SWT - Followers Number', 'swt' ), $widget_options );
	}
	
	function form( $instance ) {
		
		$defaults = array( 'twitter_followers_number' => '', 
							'facebook_followers_number' => '', 
							'gplus_followers_number' => '', 
							'twitter_url' => '', 
							'facebook_url' => '', 
							'gplus_url' => ''
						);
						
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$twitter_followers_number 	= $instance['twitter_followers_number'];
		$facebook_followers_number 	= $instance['facebook_followers_number'];
		$gplus_followers_number 	= $instance['gplus_followers_number'];
		
		$twitter_url 	= $instance['twitter_url'];
		$facebook_url 	= $instance['facebook_url'];
		$gplus_url 		= $instance['gplus_url'];
		
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'twitter_followers_number' ); ?>"><?php _e( 'Number of followers on Twitter', 'swt' ); ?></label>
			<input type="text" class="smallfat" name="<?php echo $this->get_field_name( 'twitter_followers_number' ); ?>" value="<?php echo esc_attr( $twitter_followers_number ); ?>" id="<?php echo $this->get_field_id( 'twitter_followers_number' ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'twitter_url' ); ?>"><?php _e( 'Twitter URL:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'twitter_url' ); ?>" value="<?php echo esc_url( $twitter_url ); ?>" id="<?php echo $this->get_field_id( 'twitter_url' ); ?>" />			
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'facebook_followers_number' ); ?>"><?php _e( 'Number of followers on Facebook', 'swt' ); ?></label>
			<input type="text" class="smallfat" name="<?php echo $this->get_field_name( 'facebook_followers_number' ); ?>" value="<?php echo esc_attr( $facebook_followers_number ); ?>" id="<?php echo $this->get_field_id( 'facebook_followers_number' ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'facebook_url' ); ?>"><?php _e( 'Facebook URL:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'facebook_url' ); ?>" value="<?php echo esc_url( $facebook_url ); ?>" id="<?php echo $this->get_field_id( 'facebook_url' ); ?>" />			
		</p>		

		<p>
			<label for="<?php echo $this->get_field_id( 'gplus_followers_number' ); ?>"><?php _e( 'Number of followers on Google Plus', 'swt' ); ?></label>
			<input type="text" class="smallfat" name="<?php echo $this->get_field_name( 'gplus_followers_number' ); ?>" value="<?php echo esc_attr( $gplus_followers_number ); ?>" id="<?php echo $this->get_field_id( 'gplus_followers_number' ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'gplus_url' ); ?>"><?php _e( 'Google Plus URL:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'gplus_url' ); ?>" value="<?php echo esc_url( $gplus_url ); ?>" id="<?php echo $this->get_field_id( 'gplus_url' ); ?>" />			
		</p>		
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance; 
		
		$instance['twitter_followers_number'] 	= strip_tags( $new_instance['twitter_followers_number'] );
		$instance['facebook_followers_number'] 	= strip_tags( $new_instance['facebook_followers_number'] );
		$instance['gplus_followers_number'] 	= strip_tags( $new_instance['gplus_followers_number'] );
		
		$instance['twitter_url'] 	= strip_tags( $new_instance['twitter_url'] );
		$instance['facebook_url'] 	= strip_tags( $new_instance['facebook_url'] );
		$instance['gplus_url'] 	= strip_tags( $new_instance['gplus_url'] );
						
		return $instance;
	}
	
	function widget( $args, $instance ) {
		
		extract( $args, EXTR_SKIP );
		
		$twitter_num 		= $instance['twitter_followers_number'];
		$facebook_num 		= $instance['facebook_followers_number'];
		$gplus_num 			= $instance['gplus_followers_number'];
		
		$twitter_url 		= $instance['twitter_url'];
		$facebook_url 		= $instance['facebook_url'];
		$gplus_url 			= $instance['gplus_url'];
		
		$img_dir = trailingslashit( get_template_directory_uri() ) .'images/';
		
		echo $before_widget;		
		?>
		
		<ul>
			<?php if ( !empty( $facebook_num ) && !empty( $facebook_url ) ) { ?>
				<li>
					<a class="swt-facebook" href="<?php echo esc_url( $facebook_url ); ?>" title="<?php _e( 'Join us on Facebook!', 'swt' ); ?>">
						<i class="fa fa-facebook-square"></i>
						<span class="f-num"><?php echo $facebook_num; ?></span>
						<span class="fans"><?php _e( 'Fans', 'swt' ); ?></span>
					</a>
				</li>		
			<?php } if ( !empty( $twitter_num ) && !empty( $twitter_url ) ) { ?>
				<li>								
					<a class="swt-twitter" href="<?php echo esc_url( $twitter_url ); ?>" title="<?php _e( 'Follow us on Twitter!', 'swt' ); ?>">
						<i class="fa fa-twitter-square"></i>
						<span class="f-num"><?php echo $twitter_num; ?></span>
						<span class="fans"><?php _e( 'Fans', 'swt' ); ?></span>
					</a>
				</li>
			<?php } if ( !empty( $gplus_num ) && !empty( $gplus_url ) ) { ?>
				<li class="last">
					<a class="swt-google-plus" href="<?php echo esc_url( $gplus_url ); ?>" title="<?php _e( 'Join us on Google Plus!', 'swt' ); ?>">
					<i class="fa fa-google-plus-square"></i>
					<span class="f-num"><?php echo $gplus_num; ?></span>
					<span class="fans"><?php _e( 'Fans', 'swt' ); ?></span>
					</a>				
				</li>
			<?php } ?>
		</ul>
		
		<?php
		echo $after_widget;
		
	}

}

?>