<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'swt'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

/* set some defaults */
$theme_dir = get_bloginfo( 'template_directory' );
 
$slider_mode = array(
	'fade' => __('Fade', 'swt'),
	'horizontal' => __('Horizontal', 'swt'),
	'vertical' => __('Vertical', 'swt')
);	

$slider_auto = array(
	'true' => __('Yes', 'swt'),
	'false' => __('No', 'swt')
);	

$slider_autohover = array(
	'true' => __('Yes', 'swt'),
	'false' => __('No', 'swt')
);	
	
// If using image radio buttons, define a directory path
$imagepath =  get_template_directory_uri() . '/admin/images/';

$options = array();

$options[] = array( "name" => __( "General", "swt" ),
					"type" => "heading" );

$options[] = array( "name" => __( "Default Site Layout", "swt" ),
					"desc" => "",
					"id" => "site_layout",
					"std" => "layout-2c-l",
					"type" => "images",
					"options" => array(
								'layout-1c'    => $imagepath . '1col.png',
								'layout-2c-l'  => $imagepath . '2cl.png',
								'layout-2c-r'  => $imagepath . '2cr.png',
								)
					);					
					
$options[] = array( "name" => __( "Header Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/head&gt; tag", "swt" ),
					"id" => "header_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Footer Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/body&gt; tag", "swt" ),
					"id" => "footer_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Custom CSS", "swt" ),
					"desc" => __( "Add your own CSS", "swt" ),
					"id" => "custom_css",
					"type" => "textarea",
					"std" => "");    							

$options[] = array( "name" => __( "Upload Favicon (16x16px)", "swt" ),
					"desc" => __( "A favicon (short for Favorite icon), is also known as a shortcut icon, Web site icon, URL icon or bookmark icon, most commonly 16x16 pixels, associated with a particular Web site or Web page. For example, you can generate your 16x16px favicon <a href='http://www.favicongenerator.com/'>here</a>.", "swt" ),
					"id" => "favicon",					
					"type" => "upload",
					"std" => "");	
 
$options[] = array( 'name' => __( "How to add posts to featured post area?", "swt" ),
					'desc' => __( "First thing - you need to enable featured posts by checking \"Enable featured posts\" below. Make a new post, and set a featured image for it. Save the post, and click on \"All posts\". Find the  post you just made, and click on \"Quick Edit\". Now just click on \"Make this post sticky\" and click \"Update\". Make at least three posts this way.", "swt" ),
					'type' => 'info');    		
	
$options[] = array( 'name' => '',
					"desc" => __( "Enable featured posts (checked - enabled)", "swt" ),
					'id' => 'swt_featured_posts',
					'std' => '0',
					'type' => 'checkbox');		

					
$options[] = array( 'name' => __( "Newsletter", "swt" ),
					'type' => 'heading');	

$options[] = array( 'name' => __( "Enable / Disable Mailchimp Newsletter", "swt" ),
					'desc' => __( "If enabled, social icons will appear in menu or in sidebar of theme.", "swt" ),
					'id' => 'swt_mailchimp',
					'std' => '0',
					'type' => 'checkbox' );		
										
$options[] = array( "name" => __( "Newsletter text", "swt" ),
					"desc" => '',
					"id" => "mailchimp_text",
					"type" => "text",
					"std" => "Sign up for the latest news");						

$options[] = array( "name" => __( "API key", "swt" ),
					"desc" => '<a href="https://admin.mailchimp.com/account/api-key-popup">'.__( 'Grab it here', 'swt' ).'</a>',
					"id" => "mailchimp_api_key",
					"type" => "text",
					"std" => "");		

$options[] = array( "name" => __( "List ID", "swt" ),
					"desc" => '<a href="http://kb.mailchimp.com/article/how-can-i-find-my-list-id/">'.__( 'Grab it here', 'swt' ).'</a>',
					"id" => "mailchimp_list_id",
					"type" => "text",
					"std" => "");							
	
return $options;
	
}