<?php

class tagged_posts_widget extends WP_Widget {

	function tagged_posts_widget() {
		
		$widget_options = array( 'classname' => 'swt_tagged_widget', 'description' => __( 'Displays posts with specific tag.', 'swt' ) );
		parent::WP_Widget( 'tagged_posts_widget', __( 'SWT - Tagged Posts', 'swt' ), $widget_options );
	}
	
	function form( $instance ) {
		
		$defaults = array( 'tag' => '', 'number_of_items' => 1 );
							
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$tagged 			= 	$instance['tag'];
		$number_of_items 	= 	$instance['number_of_items'];
		
		?>
 
		<p>
			<label for="<?php echo $this->get_field_id( 'tag' ); ?>"><?php _e( 'Select the tag:', 'swt' ); ?></label>		
			<select id="<?php echo $this->get_field_id( 'tag' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'tag' ); ?>">
				<?php
				$tags = get_tags();
				foreach( $tags as $tag ) { ?>
					<option value="<?php echo esc_attr( $tag->name ); ?>" <?php selected( $tagged, $tag->name ); ?>><?php echo $tag->name; ?></option>
				<?php } ?>
			</select>
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'number_of_items' ); ?>"><?php _e( 'Set the number of posts you want to show:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number_of_items' ); ?>" name="<?php echo $this->get_field_name( 'number_of_items' ); ?>" value="<?php echo esc_attr( $number_of_items ); ?>" />
		</p>		
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance; 
		
		$instance['tag'] 				= 	strip_tags( $new_instance['tag'] );
		$instance['number_of_items'] 	= 	empty( $new_instance['number_of_items'] ) ? 1 : absint( $new_instance['number_of_items'] );
		
						
		return $instance;
	}
	
	function widget( $args, $instance ) {
		
		extract( $args, EXTR_SKIP );
			
		$tag 				= 	$instance['tag']; 		
		$number_of_items 	= 	$instance['number_of_items']; 		
		
		echo $before_widget;		
		
		$query_args = array(
			'tag'					=>	$tag,
			'orderby'				=>  'comment_count', 
			'posts_per_page' 		=> 	$number_of_items,
			'ignore_sticky_posts' 	=>  true,
			'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1)
		);
		
		$query = new WP_Query( $query_args );
		
		echo '<ul id="tagged-posts" class="tagged-'.$number_of_items.'-col">';
		
		if ( $query->have_posts() ) {
 			while ( $query->have_posts() ) {
				$query->the_post();				
			?>
			
			<li>
			
			<article <?php hybrid_attr( 'post' ); ?>>
			
					<?php if ( current_theme_supports( 'get-the-image' ) ) { 
					
						$size = 'swt-full';
						
						if( $number_of_items >= 3 && $number_of_items != 5 && $number_of_items != 7 ) 
							$size = 'swt-featured-image';
						
						get_the_image( array( 'default_image' => trailingslashit( get_template_directory_uri() ) . 'images/slider-default.gif',
										  'size' => $size, 
										  'image_class' => 'swt-tagged-image aligncenter'								  
										) ); 
					} ?>	
					
					<header class="entry-header">
						
						<div class="entry-byline">
						
							<time <?php hybrid_attr( 'entry-published' ); ?>>
								<span class="month"><?php the_time( 'F' ); ?></span>
								<span class="day"><?php the_time( 'd Y' ); ?></span>
							</time>					
							
							<span <?php hybrid_attr( 'entry-author' ); ?>><?php the_author_posts_link(); ?></span>
												
						</div><!-- .entry-byline -->
						
						<h4 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h4>						
						
					</header>
					
					<div <?php hybrid_attr( 'entry-summary' ); ?>>
						<p>
							<?php echo substr( get_the_excerpt(), 0, 110 ); ?>...
							<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'read more', 'swt' ); ?></a>
						</p>
					</div><!-- .entry-summary -->					
					
			</article>
			</li>
			<?php
			} 		
			wp_reset_postdata();		

 		} 
		
		echo '</ul>';	 		
				
		echo $after_widget;
		
	}

}

?>